#include <bits/stdc++.h>
using namespace std;
typedef long long LL;

#define FOR(i,a,b) for(int i=a;i<int(b);i++)
#define MOD 1000000007

LL gx, gy, gd;
void gcd(LL a, LL b) {
	if (b == 0) {gx = 1; gy = 0; gd = a; return;}
	gcd(b, a % b);
	gx -= gy * (a / b);
	swap(gx, gy);
}
LL modinv(LL a) {
	gcd(a, MOD);
	if (gd != 1) puts("FAIL!!!");
	return gx;
}

LL modexp(LL x, LL n) {
	LL res = 1;
	while (n) {
		if (n%2) res = (res*x) % MOD;
		x = (x*x) % MOD;
		n /= 2;
	}
	return res;
}

LL M, K, N;

LL inv[5001]; // [i] = i^(-1) mod MOD

LL ack[5001][5001]; // [i][j] = (n-m+i) choose j

LL sv() {
	cin >> M >> K >> N;

	// First compute ack[][]
	for (int i = 0; i <= M; i++) {
		ack[i][0] = 1;
		for (int j = 1; j <= i; j++) {
			LL& x = ack[i][j];
			x = ack[i][j-1];
			x = (x*(N-M+i+1-j)) % MOD;
			x = (x*inv[j]) % MOD;
		}
	}

	// dp[i] = # ways to assign n-m+i people to k groups of i people
	// so that no person is in all groups
	vector<LL> dp(M+1);
	dp[0] = 1;
	for (int i = 1; i <= M; i++) {
		LL& val = dp[i];

		// Answer is the total number of possible ways to assign
		// = (n-m+i choose i)^K
		val = modexp(ack[i][i], K);

		// Minus (ways to pick j people)*dp[i-j]
		for (int j = 1; j <= i; j++) {
			LL x = (ack[i][j]*dp[i-j]) % MOD;
			val = (val-x) % MOD;
		}
		val = (val+MOD)%MOD;
	}
	return dp[M];
}

int main() {
	for (int i = 1; i < 5001; i++) inv[i] = modinv(i);
	cout << sv() << endl;
}
