#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const ll mod = 1e9 + 7;
const ll nax = 1e5+5;

ll fac[nax], ifac[nax];

void egcd(ll a, ll b, ll& x, ll& y) {
    if (b == 0) {
        x = 1, y = 0;
    } else {
        egcd(b, a%b, x, y);
        x -= a / b * y;
        swap(x, y);
    }
}

ll inv_mod(ll a) {
  ll x, y;
  egcd(a, mod, x, y);
  return (x % mod + mod) % mod;
}

ll nCk(ll n, ll k) {
  return ((fac[n] * ifac[n-k]) % mod * ifac[k]) % mod;
}

ll pow(ll b, int e) {
  b %= mod;
  if (e == 0) return 1LL;
  ll st = pow(b, e / 2);
  if (e & 1) return (((b * st) % mod) * st) % mod;
  return (st * st) % mod;
}

ll dp[nax];

int main() {
  ll m, k, n;
  cin >> m >> k >> n;
  fac[0] = ifac[0] = 1LL;
  for (int i = 1; i <= n; i++) {
    fac[i] = (i * fac[i-1]) % mod;
    ifac[i] = inv_mod(fac[i]);
  }
  dp[0] = 1LL;
  for (int i = 1; i <= m; i++) {
    int f = n - m + i; // number of free slots
	// Warning! Must cast second parameter to int, otherwise it will call the built-in C++ pow
    dp[i] = pow(nCk(f, i), (int)k);
    for (int j = 0; j < i; j++) {
      ll st = (nCk(f, i - j) * dp[j]) % mod;
      dp[i] = (dp[i] - st + mod) % mod;
    }
  }
  cout << dp[m] << endl;
}
