from sys import setrecursionlimit
from collections import deque
setrecursionlimit(10000)

N, M, B, A = map(int, input().split())
allies = set(map(int, input().split()))

G = {i: set() for i in range(N)}
for _ in range(M):
    u, v = map(int, input().split())
    G[u].add(v)
    G[v].add(u)

# A node _i_ with an ally is the same as the existance
# of paths between all neighbours of _i_.
for a in allies:
    for u in G[a]:
        for v in G[a]:
            if u != v:
                G[u].add(v)
                G[v].add(u)

seen = set()
queue = deque()
queue.append((0, B+2))
best = None
while queue:
    cur, moves_left = queue.popleft()
    seen.add(cur)

    if N-1 in G[cur]:
        best = max(best or -1, moves_left-1)
        break
    if moves_left <= 0:
        continue
    queue.extend([(neighbour, moves_left-1) for neighbour in G[cur]
                  if neighbour not in seen])

print(B+2 - best if best is not None else -1)
